/*
   
 Oled conectat: SDA la GPIO21 SCK la GPIO22
 
  se conecteaza la router local
  dupa incarcare, pe Oled si Serial Monitor 
  apare adresa IP 192.169.0.80
  Se dexchide pe Android Chrome
  Se introdice 192.168.0.80/webserial
  apare pagina web
  tot ce se editeaza  pe telefon apare pe Oled
 Se poate conecta inca un telefon cu acelasi IP
 
*/
#include <Arduino.h>
#include <WiFi.h>
#include <AsyncTCP.h>
#include <ESPAsyncWebServer.h>
#include <WebSerial.h>

AsyncWebServer server(80);

const char* ssid = "UPCF4821BC";          // Your WiFi SSID
const char* password = "Gherla1956";  // Your WiFi Password
 

#include <Adafruit_SSD1306.h>
#include <Adafruit_GFX.h>
#define OLED_ADDR   0x3C
Adafruit_SSD1306 display(-1);


/* Message callback of WebSerial */
void recvMsg(uint8_t *data, size_t len){
  WebSerial.println("Received Data...");
  String d = "";
  for(int i=0; i < len; i++){
    d += char(data[i]);
    Serial.println(d);
    display.clearDisplay();
  display.setTextSize(2);
  display.setTextColor(WHITE);
  display.setCursor(0,0);
  display.print("Primit=");
  display.print(d);//afiseaza text tranmmsis pe oled
  display.display();
  }
  WebSerial.println(d);
}

void setup() {
    Serial.begin(115200);
    WiFi.mode(WIFI_STA);
  WiFi.begin(ssid, password);
  if (WiFi.waitForConnectResult() != WL_CONNECTED) {
    Serial.printf("WiFi Failed!\n");
    return;
  }
  Serial.print("IP Address: ");
  Serial.println(WiFi.localIP());
  // WebSerial is accessible at "<IP Address>/webserial" in browser
  WebSerial.begin(&server);
  WebSerial.msgCallback(recvMsg);
  server.begin();
    
  display.begin(SSD1306_SWITCHCAPVCC, OLED_ADDR);
  display.clearDisplay();
  display.setTextSize(2);
  display.setTextColor(WHITE);
  display.setCursor(0,0);
  display.print("ESP32 webserial IP=");
  display.print(WiFi.localIP());
  display.display();
  delay(5000);
}

void loop() {
  
            }
